<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Redirects;

use Exception;
use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectInterface;
use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectInterfaceFactory;
use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectsRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

/**
 *
 */
class Edit extends Action
{
    /**
     * @var bool|PageFactory
     */
    protected $resultPageFactory = false;
    /**
     * @var RedirectsRepositoryInterface
     */
    protected $redirectRepository;
    /**
     * @var RequestInterface
     */
    private $request;
    /**
     * @var RedirectFactory
     */
    private $redirectFactory;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectsRepositoryInterface $redirectRepository
     * @param \FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectInterfaceFactory $redirectsFactory
     * @param \Magento\Framework\App\RequestInterface $request
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        RedirectsRepositoryInterface $redirectRepository,
        RedirectInterfaceFactory $redirectsFactory,
        RequestInterface $request
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->redirectFactory = $redirectsFactory;
        $this->redirectRepository = $redirectRepository;
        $this->request = $request;
    }

    /**
     * @return ResponseInterface|Redirect|ResultInterface|Page
     */
    public function execute()
    {
        $redirect = $this->getRequest()->getParam('redirect', null);

        if ($redirect !== null) {
            $id = $redirect[RedirectInterface::ID] ?? null;
            try {
                /** @var RedirectInterface $redirectObj */
                $redirectObj = $this->redirectFactory->create();

                $redirectObj
                    ->setId($redirect[RedirectInterface::ID] ?? '')
                    ->setHost($redirect[RedirectInterface::HOST] ?? '')
                    ->setRequestUrl($redirect[RedirectInterface::REQUEST_URL] ?? '')
                    ->setTargetUrl($redirect[RedirectInterface::TARGET_URL] ?? '')
                    ->setRedirectCode($redirect[RedirectInterface::REDIRECT_CODE] ?? '');

                $this->redirectRepository->save($redirectObj);
                $id = $redirectObj->getId();
                $this->messageManager->addSuccessMessage('Save success');
            } catch (Exception $exception) {
                $this->messageManager->addExceptionMessage($exception);
            }

            return $this->getRedirectPath($id);
        }

        return $this->resultPageFactory->create();
    }

    /**
     * @param string|int|null $id
     * @return Redirect
     */
    protected function getRedirectPath($id = null): Redirect
    {
        $backTo = $this->getRequest()->getParam('back', false);

        if ($id === null || $backTo === false) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        return $this->resultRedirectFactory->create()->setPath("*/*/{$backTo}", ['id' => $id]);
    }
}
