<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Indexer;

use Exception;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterfaceFactory;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Edit
 * @package FiloBlu\Refilo\Controller\Adminhtml\Indexer
 */
class Edit extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var IndexerConfigurationRepositoryInterface
     */
    private $indexerConfigurationRepository;
    /**
     * @var IndexerConfigurationInterfaceFactory
     */
    private $indexerConfigurationFactory;
    /**
     * @var ConnectorConfigurationRepositoryInterface
     */
    private $connectorConfigurationRepository;

    /**
     * Index constructor.
     * @param Context $context
     * @param IndexerConfigurationRepositoryInterface $indexerConfigurationRepository
     * @param IndexerConfigurationInterfaceFactory $indexerConfigurationFactory
     * @param ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        IndexerConfigurationRepositoryInterface $indexerConfigurationRepository,
        IndexerConfigurationInterfaceFactory $indexerConfigurationFactory,
        ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->indexerConfigurationRepository = $indexerConfigurationRepository;
        $this->indexerConfigurationFactory = $indexerConfigurationFactory;
        $this->connectorConfigurationRepository = $connectorConfigurationRepository;
    }

    /**
     * @return ResponseInterface|ResultInterface|Page
     */
    public function execute()
    {
        $general = $this->getRequest()->getParam('general');

        if ($general !== null) {
            try {
                $id = $general[IndexerConfigurationInterface::ID] ?? null;

                $indexerConfiguration = $this->indexerConfigurationFactory->create();
                if ($id) {
                    $indexerConfiguration->setId($id);
                }

                $indexerConfiguration->setIndexerId($general[IndexerConfigurationInterface::INDEXER_ID]);
                $indexerConfiguration->setIndexName($general[IndexerConfigurationInterface::INDEX_NAME]);
                $indexerConfiguration->setEnabled($general[IndexerConfigurationInterface::ENABLED]);
                $indexerConfiguration->setAllowDelete((bool)$general[IndexerConfigurationInterface::ALLOW_DELETE]);
                $indexerConfiguration->setDeleteOder($general[IndexerConfigurationInterface::DELETE_ORDER]);
                $indexerConfiguration->setEnabledMemoryOptimization($general[IndexerConfigurationInterface::ENABLED_MEMORY_OPTIMIZATION]);

                $connectorId = $general[IndexerConfigurationInterface::CONNECTOR_CONFIGURATION] ?? null;

                if (!empty($connectorId)) {
                    /** @var ConnectorConfigurationInterface $connector */
                    $connector = $this->connectorConfigurationRepository->getById($connectorId);
                    $indexerConfiguration->setConnectorConfiguration($connector);
                }

                $this->indexerConfigurationRepository->save($indexerConfiguration);

                $id = $indexerConfiguration->getId();
                $this->messageManager->addSuccessMessage('Save success');
            } catch (Exception $exception) {
                $this->messageManager->addExceptionMessage($exception);
            }

            return $this->getRedirectPath($id);
        }

        return $this->resultPageFactory->create();
    }

    /**
     * @param string|int|null $id
     * @return Redirect
     */
    protected function getRedirectPath($id = null): Redirect
    {
        $backTo = $this->getRequest()->getParam('back', false);

        if ($id === null || $backTo === false) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        return $this->resultRedirectFactory->create()->setPath("*/*/$backTo", ['id' => $id]);
    }
}
