<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\ExporterInterface;
use FiloBlu\Refilo\Model\Exporter\SearchTerms;
use FiloBlu\Refilo\Model\Exporter\AbstractExporter;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class Search
 * @package FiloBlu\Refilo\Controller\Adminhtml\Exporter
 */
class Search extends Action implements HttpGetActionInterface
{
    /**
     * @var \FiloBlu\Refilo\Model\Exporter\ExporterInterface
     */
    private $exporter;

    /**
     * Search constructor.
     * @param \FiloBlu\Refilo\Model\Exporter\ExporterInterface $exporter
     * @param Context $context
     */
    public function __construct(ExporterInterface $exporter, Context $context)
    {
        parent::__construct($context);
        $this->exporter = $exporter;
    }

    /**
     * @return ResponseInterface|ResultInterface
     * @throws \MongoDB\Driver\Exception\Exception
     */
    public function execute()
    {
        try {
            $this->exporter->export();
            $this->messageManager->addSuccessMessage(__('Search data successfully exported'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('search/term/index');
    }

}
