<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\Countries as CountriesBlock;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;

class Countries implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var CountriesBlock
     */
    private $countriesBlock;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param CountriesBlock $countriesBlock
     */
    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        CountriesBlock $countriesBlock
    )
    {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->countriesBlock = $countriesBlock;
    }

    public function execute()
    {
        try {
            //@ToDo Reimplement it as query as soon as a solution for regions is found
            $this->countriesBlock->export();
            $this->messageManager->addSuccessMessage(__('Countries data successfully synced with MongoDB'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
