<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\ContentManager as ContentManagerBlock;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;

class Contentmanager implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var ContentManagerBlock
     */
    protected $contentManager;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param ContentManagerBlock $contentManager
     */
    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        ContentManagerBlock $contentManager
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->contentManager= $contentManager;
    }

    public function execute()
    {
        try {
            $this->contentManager->export();
            $this->messageManager->addSuccessMessage(__('Content Manager successfully exported to MongoDB as Master Data'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }
}
