<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Message\ManagerInterface;
use FiloBlu\Refilo\Model\Exporter\Config as ConfigBlock;


class Config implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var ConfigBlock
     */
    private $configBlock;

    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        ConfigBlock $configBlock
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->configBlock = $configBlock;
    }

    //@ToDo !!!!Implement query logic as soon as possible!!!
    public function execute()
    {
        try {
            $this->configBlock->export();
            $this->messageManager->addSuccessMessage(__('Configurations successfully synced with MongoDB'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

    //@ToDo !!!!Implement query logic as soon as possible!!!
    private function setConfig()
    {


    }
}
