<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Remote\RatingIndexer as RatingIndex;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class RatingIndex
 * @package FiloBlu\Refilo\Console\Command
 */
class RatingIndexer extends Command
{
    protected $ratingIndexer;

    /**
     * RatingIndex constructor.
     * @param RatingIndex $ratingIndexer
     * @param string|null $name
     */
    public function __construct(
        RatingIndex $ratingIndexer,
        string $name = null
    ) {
        $this->ratingIndexer = $ratingIndexer;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $this->setName('refilo:indexer:rating');
        $this->setDescription('Rating Indexer');

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->ratingIndexer->executeFull();
        $output->writeln('<info>Success.</info>');

        return 0;
    }

}
