<?php
namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\CmsPage;
use FiloBlu\Refilo\Model\Exporter\ContentManager;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ImportMasterDataends
 * @package FiloBlu\Refilo\Console\Command
 */
class ImportMasterData extends Command {

    /**
     * @var
     */
    const NAME = 'name';

    /**
     * @var ContentManager
     */
    private $contentManager;

    /**
     * ImportMasterData constructor.
     * @param ContentManager $contentManager
     * @param string|null $name
     */
    public function __construct(
        ContentManager $contentManager,
        string $name = null
    ) {
        parent::__construct($name);
        $this->contentManager = $contentManager;
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:masterdata');
        $this->setDescription('Import Masterdata Contents');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->contentManager->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
