<?php
namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Config;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportConfig extends Command {
    const NAME = 'name';
    /**
     * @var Config
     */
    private $config;

    /**
     * ImportBlocks constructor.
     * @param Config $configBlock
     * @param string $name
     */
    public function __construct(
        Config $configBlock,
        string $name = null
    ) {
        $this->config = $configBlock;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:config');
        $this->setDescription('Import Common Configurations');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->config->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
