<?php
namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\CmsBlock;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ImportBlocks
 * @package FiloBlu\Refilo\Console\Command
 */
class ImportBlocks extends Command {
    const NAME = 'name';
    /**
     * @var CmsBlock
     */
    protected $cmsBlockExporter;

    /**
     * ImportBlocks constructor.
     * @param CmsBlock $cmsBlockExporter
     * @param string $name
     */
    public function __construct(
        CmsBlock $cmsBlockExporter,
        string $name = null
    ) {
        $this->cmsBlockExporter = $cmsBlockExporter;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:blocks');
        $this->setDescription('Import Blocks Contents');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cmsBlockExporter->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
