<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * @class SyncWishlistButton
 * @package FiloBlu\Refilo\Block\Adminhtml\System\Config
 */
class SyncWishlistButton extends Field
{
    /** @var string  */
    protected $_template = 'FiloBlu_Refilo::system/config/sync_wishlist_button.phtml';

    /**
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Context $context,
        array   $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * @return string
     */
    public function getButtonUrl()
    {
        return $this->getUrl('filoblu_refilo/sync/wishlist');
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }
}
