<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Indexer;

use FiloBlu\Refilo\Block\Adminhtml\Common\Button;

/**
 * Class SaveAndContinueButton
 */
class SaveAndContinueButton extends Button
{
    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label' => __('Save and Continue Edit'),
            'class' => 'save primary',
            'data_attribute' => [
                'mage-init' => [
                    'button' => ['event' => 'saveAndContinueEdit']
                ],
            ],
            'sort_order' => 80,
        ];
    }
}
