<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Connector;

use FiloBlu\Refilo\Block\Adminhtml\Common\Button;

/**
 * Class SaveButton
 * @package FiloBlu\Refilo\Block\Adminhtml\Connector
 */
class SaveButton extends Button
{

    /**
     * @return array
     */
    public function getButtonData()
    {
        return [
            'label'          => __('Save'),
            'class'          => 'save primary',
            'data_attribute' => [
                'mage-init' => ['button' => ['event' => 'save']]
            ],
            'sort_order'     => 90,
        ];
    }
}
