<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Api\Data;

/**
 * @package FiloBlu\Refilo\Api\Data
 * @interface GuestOrderRequestInterface
 */
interface GuestOrderRequestInterface
{
    const CUSTOMER_EMAIL = 'customer_email';
    const INCREMENT_ID = 'increment_id';
    const STORE_ID = 'store_id';
    const PROTECT_CODE = 'protect_code';
    const ORDER_ID = 'order_id';

    /**
     * @return string|null
     */
    public function getCustomerEmail();

    /**
     * @param string|null $email
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setCustomerEmail($email);

    /**
     * @param string|null $incrementId
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setIncrementId($incrementId);

    /**
     * @return string|null
     */
    public function getIncrementId();

    /**
     * @param int|null $storeId
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setStoreId($storeId);

    /**
     * @return int|null
     */
    public function getStoreId();

    /**
     * @param string|null $protectCode
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setProtectCode($protectCode);

    /**
     * @return string|null
     */
    public function getProtectCode();

    /**
     * @param int|null $orderId
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setOrderId($orderId);

    /**
     * @return int|null
     */
    public function getOrderId();
}
