<?php

namespace FiloBlu\Refilo\Ui\Component\Connector\Form;

use FiloBlu\Core\Framework\Ui\AbstractDataProvider;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorPool;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Refilo\Ui\Component\Connector\Form
 */
class DataProvider extends AbstractDataProvider
{
    /**
     * @var ConnectorConfigurationRepositoryInterface
     */
    private $connectorConfigurationRepository;
    /**
     * @var PoolInterface
     */
    private $modifierPool;
    /**
     * @var ConnectorPool
     */
    private $connectorPool;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param ConnectorPool $connectorPool
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param PoolInterface $modifierPool
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ConnectorPool $connectorPool,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        PoolInterface $modifierPool,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $searchCriteriaBuilder,
            $filterBuilder,
            $request,
            $meta,
            $data
        );

        $this->connectorConfigurationRepository = $connectorConfigurationRepository;
        $this->modifierPool = $modifierPool;
        $this->connectorPool = $connectorPool;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        /** @var ConnectorConfigurationInterface[] $items */
        $items = $this->getSearchResult()->getItems();

        $data = [];
        foreach ($items as $k => $item) {
            $id = $item->getId();
            $data[$id] = [
                ConnectorConfigurationInterface::ID            => $id,
                ConnectorConfigurationInterface::NAME          => $item->getName(),
                ConnectorConfigurationInterface::CONFIGURATION => $item->getConfiguration()->getData(),
                ConnectorConfigurationInterface::TYPE          => $this->connectorPool->getTypeFor($item->getConnector())
            ];
        }

        return $data;
    }

    /**
     * @return SearchResultInterface|SearchResultsInterface
     */
    public function getSearchResult()
    {
        return $this->connectorConfigurationRepository->getList($this->getSearchCriteria());
    }

    /**
     * @return int
     */
    #[\ReturnTypeWillChange]
    public function count()
    {
        return $this->connectorConfigurationRepository->count($this->getSearchCriteria(), true);
    }
}
