<?php

declare(strict_types=1);

use FiloBlu\Refilo\Helper\Catalog\ProductAttributeHelper;
use FiloBlu\Refilo\Remote\Entity\Product;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\Area;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\State;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$objectManager = $bootstrap->getObjectManager();
$state = $objectManager->get(State::class);
$state->setAreaCode(Area::AREA_CRONTAB);


/** @var ProductRepositoryInterface $productRepository */
//$productRepository = $objectManager->get(ProductRepositoryInterface::class);
//$product = $productRepository->get('100', false, 1);

/** @var  \FiloBlu\Refilo\Helper\Catalog\ProductAttributeHelper $helper */
$helper = $objectManager->create(ProductAttributeHelper::class);

$productRefilo = new Product();
/** @var \Magento\Store\Model\StoreManager  $storeManger */
$storeManger = $objectManager->create(Magento\Store\Model\StoreManager::class);
$storeManger->setCurrentStore(8);

/** @var \Magento\Store\Model\App\Emulation  $emulation */
$emulation = $objectManager->create(\Magento\Store\Model\App\Emulation::class);

//$emulation->startEnvironmentEmulation(
//    8,
//    Area::AREA_FRONTEND,
//    true
//);
//$result = $helper->getFilterableAttributesWithChildren($product);

foreach ($storeManger->getStores() as $store){

    $emulation->startEnvironmentEmulation(
    $store->getId(),
    Area::AREA_FRONTEND,
    true
);
    print_r($store->getId());
    print_r(PHP_EOL);
    print_r($helper->getSwatchByOptionId(18));
    $emulation->stopEnvironmentEmulation();
}
$result = $helper->getSwatchByOptionId(18);

print_r($result);





