<?php

namespace FiloBlu\Refilo\Remote\IndexerConfiguration;

use FiloBlu\Core\Framework\Model\RepositoryItem;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;

/**
 * Class IndexerConfiguration
 * @package FiloBlu\Refilo\Remote\IndexerConfiguration
 */
class IndexerConfiguration implements IndexerConfigurationInterface
{
    /**
     * @var string
     */
    protected $id;
    /**
     * @var ConnectorConfigurationInterface
     */
    protected $connectorConfiguration;
    /**
     * @var string
     */
    protected $indexerId;
    /**
     * Remote connector indexer name
     * @var string
     */
    protected $indexName;

    /**
     * @var bool
     */
    protected $enabled = false;

    /**
     * @var bool
     */
    private $allowDelete = false;

    /**
     * @var int
     */
    private $deleteOder = self::DELETE_ORDER_BEFORE_INDEXER;

    /**
     * @var bool
     */
    private $enabledMemoryOptimization = false;

    /**
     * @return ConnectorConfigurationInterface
     */
    public function getConnectorConfiguration(): ConnectorConfigurationInterface
    {
        return $this->connectorConfiguration;
    }

    /**
     * @param \FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface|null $connectorConfiguration
     * @return $this|IndexerConfigurationInterface
     */
    public function setConnectorConfiguration(?ConnectorConfigurationInterface $connectorConfiguration): IndexerConfigurationInterface
    {
        $this->connectorConfiguration = $connectorConfiguration;
        return $this;
    }

    /**
     * @return string
     */
    public function getIndexName()
    {
        return $this->indexName;
    }

    /**
     * @param string $name
     * @return $this|IndexerConfigurationInterface
     */
    public function setIndexName(string $name): IndexerConfigurationInterface
    {
        $this->indexName = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIndexerId()
    {
        return $this->indexerId;
    }

    /**
     * @param string $id
     * @return $this|IndexerConfigurationInterface
     */
    public function setIndexerId(string $id): IndexerConfigurationInterface
    {
        $this->indexerId = $id;
        return $this;
    }

    /**
     * @return int|string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param $id
     * @return $this|RepositoryItem
     */
    public function setId($id): RepositoryItem
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return bool
     */
    public function hasConnectorConfiguration(): bool
    {
        return $this->connectorConfiguration !== null;
    }

    /**
     * @param $enable
     * @return $this|IndexerConfigurationInterface
     */
    public function setEnabled($enable) : IndexerConfigurationInterface
    {
        $this->enabled = $enable;
        return $this;
    }

    /**
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $allow
     * @return \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface
     */
    public function setAllowDelete(bool $allow): IndexerConfigurationInterface
    {
       $this->allowDelete = $allow;
       return $this;
    }

    /**
     * @return bool
     */
    public function getAllowDelete(): bool
    {
        return (bool)$this->allowDelete;
    }

    /**
     * @param int $order
     * @return \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface
     */
    public function setDeleteOder(int $order): IndexerConfigurationInterface
    {
        $this->deleteOder = $order;
        return $this;
    }

    /**
     * @return int
     */
    public function getDeleteOrder(): int
    {
       return (int)$this->deleteOder;
    }

    /**
     * @param bool $enabledMemoryOptimization
     * @return \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface
     */
    public function setEnabledMemoryOptimization(bool $enabledMemoryOptimization): IndexerConfigurationInterface
    {
        $this->enabledMemoryOptimization = $enabledMemoryOptimization;
        return $this;
    }

    /**
     * @return bool
     */
    public function getEnabledMemoryOptimization(): bool
    {
        return (bool)$this->enabledMemoryOptimization;
    }
}
