<?php

namespace FiloBlu\Refilo\Remote\Entity;

use Magento\Framework\DataObject;
use Magento\Framework\ObjectManager\NoninterceptableInterface;

/**
 * Class AbstractEntity
 * @package FiloBlu\Refilo\Remote\Model
 */
class AbstractEntity extends DataObject implements EntityInterface, \JsonSerializable, NoninterceptableInterface
{
    /** @var string  */
    const ID = 'id';

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->getData(self::ID);
    }

    /**
     * @param $id
     * @return $this|EntityInterface
     */
    public function setId($id): EntityInterface
    {
        $this->setData(self::ID, $id);
        return $this;
    }

    /**
     * @param array $keys
     * @return array
     */
    public function toArray(array $keys = [])
    {
        if (empty($keys)) {
            return $this->_data;
        }

        $result = [];
        foreach ($keys as $key) {
            if (isset($this->_data[$key])) {
                if ($this->_data[$key] instanceof DataObject) {
                    $result[$key] = $this->_data[$key]->toArray();
                } else {
                    $result[$key] = $this->_data[$key];
                }
            } else {
                $result[$key] = null;
            }
        }
        return $result;
    }

    /**
     * @return array|mixed|null
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize ()
    {
        return $this->getData();
    }
}
