<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Connector;

use FiloBlu\Refilo\Remote\Entity\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Interface ConnectorInterface
 * @package FiloBlu\Refilo\Remote\Connector
 */
interface ConnectorInterface
{

    /** @var string */
    const CONFIGURATION_HOST_POOL = 'hosts';

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject;

    /**
     * @param DataObject $configuration
     * @return ConnectorInterface
     */
    public function configure(DataObject $configuration): ConnectorInterface;

    /**
     * @return ConnectorInterface
     */
    public function connect(): ConnectorInterface;

    /**
     * @return ConnectorInterface
     */
    public function disconnect(): ConnectorInterface;

    /**
     * @param iterable $entities
     * @param string $collection
     * @return mixed
     */
    public function create(iterable $entities, string $collection);

    /**
     * @param iterable $entities
     * @param string $collection
     * @return mixed
     */
    public function update(iterable $entities, string $collection);

    /**
     * @param EntityInterface[]|int[]|string[] $entities
     * @param string $collection
     * @return mixed
     */
    public function delete(iterable $entities, string $collection);

}
