<?php

namespace FiloBlu\Refilo\Remote\Connector;

use FiloBlu\Core\Framework\Model\RepositoryItem;
use Magento\Framework\DataObject;

/**
 * Interface ConnectorConfigurationInterface
 * @package FiloBlu\Refilo\Remote\Connector
 */
interface ConnectorConfigurationInterface extends RepositoryItem
{
    /** @var string */
    const ID = 'id';
    /** @var string */
    const NAME = 'name';
    /** @var string */
    const TYPE = 'type';
    /** @var string */
    const CONFIGURATION = 'configuration';
    /** @var string  */
    const ENABLED = 'enabled';
    /**
     * @param $name
     * @return ConnectorConfigurationInterface
     */
    public function setName($name): ConnectorConfigurationInterface;

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @param ConnectorInterface $connector
     * @return ConnectorConfigurationInterface
     */
    public function setConnector(ConnectorInterface $connector): ConnectorConfigurationInterface;

    /**
     * @return ConnectorInterface
     */
    public function getConnector(): ConnectorInterface;

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject;

    /**
     * @param DataObject $configuration
     * @return $this|ConnectorConfigurationInterface
     */
    public function setConfiguration(DataObject $configuration): ConnectorConfigurationInterface;
}
