<?php

namespace FiloBlu\Refilo\Remote\Connector;

use Magento\Framework\DataObject;
use Magento\Framework\DataObjectFactory;
use Psr\Log\LoggerInterface;

/**
 * Class AbstractConnector
 * @package FiloBlu\Refilo\Remote\Connector
 */
abstract class AbstractConnector implements ConnectorInterface
{
    /**
     * @var DataObject
     */
    protected $configuration;

    /**
     * @var DataObjectFactory
     */
    protected $dataObjectFactory;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @var DataObject
     */
    protected $metadata;

    /**
     * AbstractConnector constructor.
     * @param DataObjectFactory $dataObjectFactory
     * @param LoggerInterface $logger
     */
    public function __construct(
        DataObjectFactory $dataObjectFactory,
        LoggerInterface $logger
    )
    {
        $this->dataObjectFactory = $dataObjectFactory;
        $this->logger = $logger;
    }

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject
    {
        if ($this->configuration !== null) {
            return $this->configuration;
        }

        return ($this->configuration = $this->dataObjectFactory->create());
    }

    /**
     * @param DataObject $configuration
     * @return ConnectorInterface
     */
    public function configure(DataObject $configuration): ConnectorInterface
    {
        $this->configuration = $configuration;
        return $this;
    }

    /**
     * @return DataObject
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * @param DataObject $metadata
     * @return $this
     */
    public function setMetadata(DataObject $metadata)
    {
        $this->metadata = $metadata;
        return $this;
    }
}
