<?php

namespace FiloBlu\Refilo\Remote;

use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class CatalogProdutIndexer
 * @package FiloBlu\Refilo\Remote
 */
class AttributeIndexer extends AbstractStoreBasedIndexer
{
    /** @var string */
    public const REFILO_CONFIG_PRICE_FILTERABLE_RANGE_STEP = 'refilo_catalog/categories/price_filterable_range_step';

    /**
     * @param $entities
     * @param $collection
     * @return mixed|void
     * @throws NoSuchEntityException
     */
    public function write($entities, $collection)
    {
        $this->getConnector()->create($entities, $collection);
    }

    /**
     * @param StoreInterface $store
     * @return DataObject
     * @throws LocalizedException
     */
    public function prepareConnectorMetadata(StoreInterface $store): DataObject
    {
        $metadata = parent::prepareConnectorMetadata($store);
        $metadata->setData('name', 'attributes');
        $refiloPriceRange = (int)$this->getScopeConfig()->getValue(self::REFILO_CONFIG_PRICE_FILTERABLE_RANGE_STEP, ScopeInterface::SCOPE_STORE, $store);
        $metadata->setData('filterable_range_step', ($refiloPriceRange < 10) ? 10 : $refiloPriceRange);
        return $metadata;
    }

    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }
}
