<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins;

use Magento\Quote\Model\Quote\Item;
use Throwable;

/**
 * Class Cartitem
 * @package FiloBlu\Refilo\Plugins
 */
class Cartitem
{
    /**
     * @param Item $subject
     * @param $result
     * @return mixed
     */
    public function afterGetExtensionAttributes(Item $subject, $result)
    {
        try {
            $product = $subject->getProduct();
            $result->setFilobluRowTotal($subject->getRowTotalInclTax());

            if($product) {
                $result->setFilobluParentSku($product->getData('sku'));
                $result->setFilobluPrice($subject->getPriceInclTax());
            }

        } catch (Throwable $throwable) {
            return $result;
        }

        return $result;
    }
}
