<?php

namespace FiloBlu\Refilo\Plugins\Api;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class AccountManagementInterface
 * @package FiloBlu\Refilo\Plugins\Api
 */
class AccountManagementInterface
{
    /**
     * @var ManagerInterface
     */
    private $eventManager;

    /**
     * AccountManagementInterface constructor.
     * @param ManagerInterface $eventManager
     */
    public function __construct(ManagerInterface $eventManager)
    {
        $this->eventManager = $eventManager;
    }

    /**
     * @param $subject
     * @param $result
     * @param CustomerInterface $customer
     * @return mixed
     * @throws \Exception
     */
    public function afterCreateAccount($subject, $result, CustomerInterface $customer)
    {
        $this->eventManager->dispatch(
            'customer_register_success',
            [
                'account_controller' => null,
                'customer'           => $customer
            ]
        );

        return $result;
    }
}
