<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use Magento\Store\Model\StoreManager;

/**
 *
 */
class LimitedStoreManager extends StoreManager
{

    /**
     * @var array
     */
    protected $allowedStores = [];

    /**
     * @inheritdoc
     */
    public function getStores($withDefault = false, $codeKey = false)
    {
        $stores = [];

        foreach ($this->allowedStores as $store)
        {
            if ($codeKey)
            {
                $stores[$store->getCode()] = $store;
                continue;
            }

            $stores[$store->getId()] = $store;
        }

        return $stores;
    }

    /**
     * @param array $allowedStores
     * @return $this
     */
    public function setAllowedStores(array $allowedStores): LimitedStoreManager
    {
        $this->allowedStores = $allowedStores;
        return $this;
    }

}