<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Data\OrderMapping;

use FiloBlu\Refilo\Api\Data\IsInStoreInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * @class IsInStore
 * @package FiloBlu\Refilo\Model\Data\OrderMapping
 */
class IsInStore extends AbstractModel implements IsInStoreInterface
{
    /**
     * @return array|mixed|null
     */
    public function getIsInStore()
    {
        return $this->getData(self::IS_IN_STORE);
    }

    /**
     * @param $isInStore
     * @return $this|mixed
     */
    public function setIsInStore($isInStore)
    {
        $this->setData(self::IS_IN_STORE, $isInStore);
        return $this;
    }
}