<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Config\Source;

use FiloBlu\Refilo\Model\PriceFilterStrategyProvider;
use Magento\Framework\Data\OptionSourceInterface;

/**
 *
 */
class PriceFilterStrategy implements OptionSourceInterface
{
    /**
     * @var \FiloBlu\Refilo\Model\PriceFilterStrategyProvider
     */
    private $priceFilterStrategyProvider;

    /**
     * @param \FiloBlu\Refilo\Model\PriceFilterStrategyProvider $priceFilterStrategyProvider
     */
    public function __construct(PriceFilterStrategyProvider $priceFilterStrategyProvider)
    {
        $this->priceFilterStrategyProvider = $priceFilterStrategyProvider;
    }

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->priceFilterStrategyProvider->getAll() as $name => $value) {
            $options[] = [
                'value' => $name,
                'label' => $value
            ];
        }

        return $options;
    }
}
