<?php

namespace FiloBlu\Refilo\Model;

use FiloBlu\Refilo\Api\CartManagementInterface;

class CartManagement implements CartManagementInterface
{
    /**
     * @var \Magento\Quote\Api\GuestCartRepositoryInterface
     */
    private $guestCartRepository;
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    private $cartRepository;

    public function __construct(
        \Magento\Quote\Api\GuestCartRepositoryInterface $guestCartRepository,
        \Magento\Quote\Api\CartRepositoryInterface $cartRepository
    ){
        $this->guestCartRepository = $guestCartRepository;
        $this->cartRepository = $cartRepository;
    }

    /**
     * @param string $cartId
     * @return true
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function emptyGuestCart(string $cartId){
        $cart = $this->guestCartRepository->get($cartId);
        $cart->removeAllItems();
        $this->cartRepository->save($cart);
        return true;
    }

    /**
     * @param int $cartId
     * @return true
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function emptyCart(int $cartId)
    {
        $cart = $this->cartRepository->get($cartId);
        $cart->removeAllItems();
        $this->cartRepository->save($cart);
        return true;
    }
}
