<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Adapter;

/**
 *
 */
abstract class AbstractAdapter
{
    /**
     * @var
     */
    protected $_connection;

    /**
     * @return mixed
     */
    abstract public function connect();

    /**
     * @param $collection
     * @param $mongoDatabase
     * @return mixed
     */
    abstract public function dropCollection($collection, $mongoDatabase);

    /**
     * @param $key
     * @param $objects
     * @param $store
     * @param $insertMode
     * @param $mongoDatabase
     * @return mixed
     */
    abstract public function update($key, $objects, $store, $insertMode, $mongoDatabase);

}
