<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Message\ManagerInterface;
use FiloBlu\Refilo\Model\Exporter\Redirects as RedirectsExporter;

/**
 *
 */
class Redirects implements HttpGetActionInterface
{
    /**
     * @var ManagerInterface
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var RedirectsExporter
     */
    private $redirects;


    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param RedirectsExporter $redirectsExporter
     */
    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        RedirectsExporter $redirectsExporter
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->redirects = $redirectsExporter;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        try {
            $this->redirects->export();
            $this->messageManager->addSuccessMessage(__('Redirects successfully synced'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
