<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\Menu as MenuExporter;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Message\ManagerInterface;

/**
 *
 */
class Menu implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var MenuExporter
     */
    private $menuExporter;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param MenuExporter $menuExporter
     */
    public function __construct(
        ResultFactory    $resultFactory,
        ManagerInterface $messageManager,
        MenuExporter     $menuExporter
    )
    {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->menuExporter = $menuExporter;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        try {
            $this->menuExporter->export();
            $this->messageManager->addSuccessMessage(__('Menu data successfully synced'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
