<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\CmsBlock as CmsBlockBlock;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;

/**
 * Class Cmsblocks
 * @package FiloBlu\Refilo\Controller\Adminhtml\Exporter
 */
class Cmsblocks implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var CmsBlockBlock
     */
    protected $cmsBlock;

    /**
     * Cmsblocks constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param CmsBlockBlock $cmsBlock
     */
    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        CmsBlockBlock $cmsBlock
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->cmsBlock = $cmsBlock;
    }

    public function execute()
    {
        try {
            $this->cmsBlock->export();
            $this->messageManager->addSuccessMessage(__('CMS blocks successfully synced with MongoDB'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }
}
