<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\ContentType\Content;

use Magento\Backend\App\AbstractAction;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Blackbird\ContentManager\Model\ResourceModel\Content\CollectionFactory as ContentCollectionFactory;

class Metadata extends AbstractAction
{
    /**
     * @var ContentCollectionFactory
     */
    protected $contentCollectionFactory;

    /**
     * DataProvider constructor.
     * @param Context $context
     * @param ContentCollectionFactory $contentCollectionFactory
     */
    public function __construct(
        Context $context,
        ContentCollectionFactory $contentCollectionFactory
    ) {
        parent::__construct($context);

        $this->contentCollectionFactory = $contentCollectionFactory;
    }

    public function execute()
    {
        $params = $this->getRequest()->getParams();
        try {
            $collection = $this->contentCollectionFactory->create();
            $contents = $collection
                ->addFieldToSelect('*')
                ->addFieldToFilter('entity_id', ['eq' => $params['entity_id']])
                ->load();
            $result = $contents->getFirstItem()->toArray();
        } catch (\Exception $e) {
            $result = [
                'error' => $e->getMessage(),
                'errorcode' => $e->getCode()
            ];
        }
        return $this->resultFactory->create(ResultFactory::TYPE_JSON)->setData($result);
    }
}
