<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Translations;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportTranslations extends Command
{
    const NAME = 'name';
    /**
     * @var Translations
     */
    private $translations;


    /**
     * ImportBlocks constructor.
     * @param Translations $redirects
     * @param string $name
     */
    public function __construct(
        Translations $redirects,
        string $name = null
    ) {
        $this->translations = $redirects;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:translations');
        $this->setDescription('Import Translations');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \MongoDB\Driver\Exception\Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->translations->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
