<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Connector;

use FiloBlu\Refilo\Block\Adminhtml\Common\Button;

/**
 *
 */
class BackButton extends Button
{
    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label' => __('Back'),
            'on_click' => sprintf("location.href = '%s';", $this->getUrl('*/*/')),
            'class' => 'back',
            'sort_order' => 10
        ];
    }
}
