<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

use FiloBlu\Refilo\Api\Data\OrderMappingInterface;

/**
 * @interface OrderMappingRepositoryInterface
 * @package FiloBlu\Refilo\Api
 */
interface OrderMappingRepositoryInterface
{
    /**
     * @param OrderMappingInterface $orderMapping
     * @return OrderMappingInterface
     */
    public function save(OrderMappingInterface $orderMapping);

    /**
     * @param $customerId
     * @param $orderId
     * @return mixed
     */
    public function get($customerId, $orderId);

    /**
     * @param $customerId
     * @param array $storeIds
     * @return mixed
     */
    public function getByCustomerId($customerId, array $storeIds = []);
}
