<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api\Data;

/**
 *
 */
interface ProductCustomOptionValueInterface
{
    /** @var string */
    public const ID = 'id';
    /** @var string */

    public const SKU = 'sku';
    /** @var string */

    public const CODE = 'code';
    /** @var string */

    public const LABEL = 'label';
    /** @var string */

    public const PRICE = 'price';

    /**
     * @return int
     */
    public function getId() :int;

    /**
     * @return string|null
     */
    public function getSku(): ?string;

    /**
     * @return string|null
     */
    public function getCode() :?string;

    /**
     * @return string|null
     */
    public function getLabel() :?string;

    /**
     * @return float
     */
    public function getPrice(): float;

    /**
     * @param int $id
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface
     */
    public function setId(int $id) : ProductCustomOptionValueInterface;

    /**
     * @param string|null $sku
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface
     */
    public function setSku(?string $sku) : ProductCustomOptionValueInterface;

    /**
     * @param string $code
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface
     */
    public function setCode(string $code): ProductCustomOptionValueInterface;

    /**
     * @param string|null $label
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface
     */
    public function setLabel(?string $label) : ProductCustomOptionValueInterface;

    /**
     * @param float $price
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface
     */
    public function setPrice(float $price) : ProductCustomOptionValueInterface;

}