<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Setup\Patch\Data;

use FiloBlu\Refilo\Setup\Converters\SliderToFiloBluSlider;
use FiloBlu\Refilo\Setup\UpgradeContentHelper;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 *
 */
class UpdateFiloBluSlider implements DataPatchInterface
{
    /**
     * @var \FiloBlu\Refilo\Setup\UpgradeContentHelper
     */
    private $upgradeContentHelper;

    /**
     * @param \FiloBlu\Refilo\Setup\UpgradeContentHelper $upgradeContentHelper
     */
    public function __construct(UpgradeContentHelper $upgradeContentHelper)
    {
        $this->upgradeContentHelper = $upgradeContentHelper;
    }

    /**
     * Get array of patches that have to be executed prior to this.
     *
     * Example of implementation:
     *
     * [
     *      \Vendor_Name\Module_Name\Setup\Patch\Patch1::class,
     *      \Vendor_Name\Module_Name\Setup\Patch\Patch2::class
     * ]
     *
     * @return string[]
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * Get aliases (previous names) for the patch.
     *
     * @return string[]
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @return void
     * @throws \Magento\Framework\DB\FieldDataConversionException
     */
    public function apply()
    {
        $this->upgradeContentHelper->upgrade(
            '%data-content-type="slide"%',
            [SliderToFiloBluSlider::class]
        );
    }
}
