
# Refilo Core Module

## Known Issues

- `beehive_price` did not work correctly with configurable products.
- Removed `\FiloBlu\Refilo\Helper\Indexer::fixPriceIndex` before executing `beehive_price`.
- Magento now updates configurable prices correctly.
- Magento renames `catalog_product_index_price_replica` during price calculations in `catalog_product_index_price`.

## Trigger Management

To prevent triggers on `catalog_product_index_price` from being lost during table renaming, use the plugin:
- `\FiloBlu\Indexer\Plugin\Catalog\Model\ResourceModel\Indexer\RestoreTriggerAfterSwitch::aroundSwitchTable`
- Enable the configuration: `filoblu_indexer/trigger_plugins/enabled`
- Triggers are managed by: `\FiloBlu\Indexer\Model\TriggerManipulator::createTriggers`

## Steps After Enabling

1. Check triggers in the database.
2. If triggers exist on `catalog_product_index_price_replica`, delete them and then regenerate them after enabling the configuration.

## Regenerate Triggers

Set indexers to realtime:
```bash
php bin/magento indexer:set-mode realtime catalog_product_price beehive_price
```

Then reset to schedule:
```bash
php bin/magento indexer:set-mode schedule catalog_product_price beehive_price
```
