<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * @package FiloBlu\Refilo\Model
 * @class GuestOrderRequest
 */
class GuestOrderRequest extends AbstractModel implements GuestOrderRequestInterface
{
    /**
     * @return string|null
     */
    public function getCustomerEmail()
    {
        return $this->getData(self::CUSTOMER_EMAIL);
    }

    /**
     * @param string|null $email
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setCustomerEmail($email)
    {
        $this->setData(self::CUSTOMER_EMAIL, $email);
        return $this;
    }

    /**
     * @param string|null $incrementId
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setIncrementId($incrementId)
    {
        $this->setData(self::INCREMENT_ID, $incrementId);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIncrementId()
    {
        return $this->getData(self::INCREMENT_ID);
    }

    /**
     * @param int|null $storeId
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setStoreId($storeId)
    {
        $this->setData(self::STORE_ID, $storeId);
        return $this;
    }

    /**
     * @return int|null
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @param string|null $protectCode
     * @return \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface
     */
    public function setProtectCode($protectCode)
    {
        return $this->setData(self::PROTECT_CODE, $protectCode);
    }

    /**
     * @return string|null
     */
    public function getProtectCode()
    {
        return $this->getData(self::PROTECT_CODE);
    }

    /**
     * @param int|null $orderId
     * @return GuestOrderRequestInterface
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID , $orderId);
    }

    /**
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }
}
