<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\Urls as UrlExporter;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Message\ManagerInterface;

/**
 *
 */
class Urls implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var UrlExporter
     */
    private $urlExporter;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param UrlExporter $urlExporter
     */
    public function __construct(
        ResultFactory    $resultFactory,
        ManagerInterface $messageManager,
        UrlExporter      $urlExporter
    )
    {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->urlExporter = $urlExporter;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        try {
            $this->urlExporter->export();
            $this->messageManager->addSuccessMessage(__('URLs data successfully synced'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
