<?php

namespace FiloBlu\Refilo\Block\Adminhtml\System\Config\Form\Field;

use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;

/**
 *
 */
class Country extends Select
{
    /**
     * @var \Magento\Directory\Model\Config\Source\Country
     */
    public $country;

    /**
     * @param \Magento\Framework\View\Element\Context $context
     * @param \Magento\Directory\Model\Config\Source\Country $country
     * @param array $data
     */
    public function __construct(
        Context $context,
        \Magento\Directory\Model\Config\Source\Country $country,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->country = $country;
    }


    /**
     * Render block HTML
     *
     * @return string
     */
    public function _toHtml()
    {
        $this->setExtraParams('multiple="multiple"');
        $this->setOptions($this->country->toOptionArray(true));

        return parent::_toHtml();
    }

    /**
     * @param $value
     * @return mixed
     */
    public function setInputName($value)
    {
        return $this->setName($value . '[]');
    }
}
