<?php

namespace FiloBlu\Refilo\Plugins;

use Magento\Cms\Model\Block\DataProvider;

class BlockDataProvider
{
    /**
     * @param DataProvider $subject
     * @param $result
     * @return mixed
     */
    public function afterGetData(DataProvider $subject, $result)
    {
        if ($result !== null && isset($result)) {
            //@ToDo remove reference to $block
            foreach ($result as &$block) {
                if (!isset($block['display_on']) || empty($block['display_on'])) {
                    continue;
                }
                if ($block['display_on'] === 'categories' || $block['display_on'] === 'cms_pages') {
                    $block['selection_target'] = explode(',', $block['selection_target']);
                }

                $block["{$block['display_on']}_selection"] = $block['selection_target'];
            }
            return $result;
        }
        return null;
    }
}
