<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Cron;

use FiloBlu\Refilo\Model\Importer\Wishlist;
use Psr\Log\LoggerInterface;

/**
 * @class WishlistImporterJob
 * @package FiloBlu\Refilo\Cron
 */
class WishlistImporterJob
{

    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var Wishlist
     */
    private $wishlist;

    /**
     * @param LoggerInterface $logger
     * @param Wishlist $wishlist
     */
    public function __construct(
        LoggerInterface $logger,
        Wishlist $wishlist
    ) {
        $this->logger = $logger;
        $this->wishlist = $wishlist;
    }

    /**
     * Executes the WishlistImporterJob cron task.
     *
     * This method executes an import of all the MongoDB wishlists in Magento DB, logging any errors encountered
     * during the process
     *
     * @return void
     */
    public function execute()
    {
        try {
            $this->logger->info('[WishlistImporterJob] Cron started');
            $this->wishlist->execute();
            $this->logger->info('[WishlistImporterJob] Cron completed successfully');
        } catch (\Throwable $e) {
            $this->logger->error('[WishlistImporterJob] Cron failed: ' . $e->getMessage());
            $this->logger->error($e->getTraceAsString());
        }
    }
}
