<?php

namespace FiloBlu\Refilo\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

use function is_array;

/**
 * Class BlockPrepareSaveObserver
 * @package FiloBlu\Refilo\Model\Observer
 */
class BlockPrepareSaveObserver implements ObserverInterface
{

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $object = $observer->getEvent()->getDataObject();
        if (is_array($object->getCustomerGroup())) {
            $object->setData(
                'customer_group',
                ($object->getCustomerGroup() ? implode(',', $object->getCustomerGroup()) : null)
            );
        } else {
            $object->setData('customer_group', ($object->getCustomerGroup() ?: null));
        }
    }

}
