<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Config\Source;

use FiloBlu\Refilo\Model\RoundingStrategyProvider;
use Magento\Framework\Data\OptionSourceInterface;

/**
 *
 */
class RoundingStrategy implements OptionSourceInterface
{
    /**
     * @var \FiloBlu\Refilo\Model\RoundingStrategyProvider
     */
    private $roundingStrategyProvider;

    /**
     * @param \FiloBlu\Refilo\Model\RoundingStrategyProvider $roundingStrategyProvider
     */
    public function __construct(RoundingStrategyProvider $roundingStrategyProvider)
    {
        $this->roundingStrategyProvider = $roundingStrategyProvider;
    }

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->roundingStrategyProvider->getAll() as $name => $value) {
            $options[] = [
                'value' => $name,
                'label' => __($name)
            ];
        }

        return $options;
    }
}