<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\CmsPage;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ImportPages
 * @package FiloBlu\Refilo\Console\Command
 */
class ImportPages extends Command {
    const NAME = 'name';

    /**
     * @var CmsPage
     */
    protected $cmsPageExporter;

    /**
     * ImportBlocks constructor.
     * @param CmsPage $cmsPageExporter
     * @param string $name
     */
    public function __construct(
        CmsPage $cmsPageExporter,
        string $name = null
    ) {
        $this->cmsPageExporter = $cmsPageExporter;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:pages');
        $this->setDescription('Import Pages Contents');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cmsPageExporter->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
