<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Redirects;

use Exception;
use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectsRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 *
 */
class Delete extends Action
{
    /**
     * @var RedirectsRepositoryInterface
     */
    protected $redirectRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param RedirectsRepositoryInterface $redirectRepository
     */
    public function __construct(Context $context, RedirectsRepositoryInterface $redirectRepository)
    {
        parent::__construct($context);
        $this->redirectRepository = $redirectRepository;
    }

    /**
     * @return ResponseInterface|ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id', null);
        if ($id === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        try {
            $this->redirectRepository->deleteById($id);
            $this->messageManager->addSuccessMessage(__('Deleted Redirect with id %1', $id));
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }
}
