<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

/**
 * @interface OrderMappingManagementInterface
 * @package FiloBlu\Refilo\Api
 */
interface OrderMappingManagementInterface
{
    /**
     * @param int $customerId
     * @return string
     */
    public function getOrderIdByCustomer($customerId);

    /**
     * @param \FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface $request
     * @return \Magento\Sales\Api\Data\OrderSearchResultInterface
     */
    public function getGuestOrder(\FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface $request);

    /**
     * @param \FiloBlu\Refilo\Api\Data\CustomerOrderRequestInterface $request
     * @return \Magento\Sales\Api\Data\OrderSearchResultInterface
     */
    public function getCustomerOrder(\FiloBlu\Refilo\Api\Data\CustomerOrderRequestInterface $request);
}
