<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Api\Data;

/**
 * @package FiloBlu\Refilo\Api\Data
 * @interface CustomerOrderRequestInterface
 */
interface CustomerOrderRequestInterface
{
    const CUSTOMER_ID = 'customer_id';
    const ORDER_ID = 'order_id';
    const STORE_ID = 'store_id';
    const PAGE_SIZE = 'page_size';
    const PAGE_NUMBER = 'page_number';

    /**
     * @return mixed
     */
    public function getCustomerId();

    /**
     * @param $customerId
     * @return mixed
     */
    public function setCustomerId($customerId);

    /**
     * @param $orderId
     * @return mixed
     */
    public function setOrderId($orderId);

    /**
     * @return mixed
     */
    public function getOrderId();

    /**
     * @param $storeId
     * @return mixed
     */
    public function setStoreId($storeId);

    /**
     * @return mixed
     */
    public function getStoreId();

    /**
     * @return mixed
     */
    public function getPageSize();

    /**
     * @param $pageSize
     * @return mixed
     */
    public function setPageSize($pageSize);

    /**
     * @return mixed
     */
    public function getPageNumber();

    /**
     * @param $pageNumber
     * @return mixed
     */
    public function setPageNumber($pageNumber);
}
